<?php
/**
 * LoginRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  HelixWebServices
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2015 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace HelixWebServices\Model;

use \ArrayAccess;
/**
 * LoginRequest Class Doc Comment
 *
 * @category    Class
 * @description Captures the login information we need for logging into either a p4d server or our \&quot;authentication source\&quot;.
 * @package     HelixWebServices
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LoginRequest implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    static $swaggerTypes = array(
        'user' => 'string',
        'password' => 'string',
        'server_logins' => '\HelixWebServices\Model\ServerLoginRequest[]'
    );

    /**
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[]
      */
    static $attributeMap = array(
        'user' => 'user',
        'password' => 'password',
        'server_logins' => 'serverLogins'
    );

    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'user' => 'setUser',
        'password' => 'setPassword',
        'server_logins' => 'setServerLogins'
    );

    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'user' => 'getUser',
        'password' => 'getPassword',
        'server_logins' => 'getServerLogins'
    );

    
    /**
      * $user Usually the Perforce username
      * @var string
      */
    protected $user;
    
    /**
      * $password 
      * @var string
      */
    protected $password;
    
    /**
      * $server_logins 
      * @var \HelixWebServices\Model\ServerLoginRequest[]
      */
    protected $server_logins;
    

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["user"])) {
              $this->user = $data["user"];
            }
            if (isset($data["password"])) {
              $this->password = $data["password"];
            }
            if (isset($data["server_logins"])) {
              $this->server_logins = $data["server_logins"];
            }
        }
    }
    
    /**
     * Gets user
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Sets user
     * @param string $user Usually the Perforce username
     * @return $this
     */
    public function setUser($user)
    {
        
        $this->user = $user;
        return $this;
    }
    
    /**
     * Gets password
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Sets password
     * @param string $password 
     * @return $this
     */
    public function setPassword($password)
    {
        
        $this->password = $password;
        return $this;
    }
    
    /**
     * Gets server_logins
     * @return \HelixWebServices\Model\ServerLoginRequest[]
     */
    public function getServerLogins()
    {
        return $this->server_logins;
    }

    /**
     * Sets server_logins
     * @param \HelixWebServices\Model\ServerLoginRequest[] $server_logins 
     * @return $this
     */
    public function setServerLogins($server_logins)
    {
        
        $this->server_logins = $server_logins;
        return $this;
    }
    
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(get_object_vars($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(get_object_vars($this));
        }
    }
}
