# Changing the Commit Server ServerID - What to Expect

This document describes the impact and considerations involved in changing the ServerID of a commit server in a P4 Server topology.

Changing the commit ServerID is generally motiviated by being in alignment with modern SDP conventions.  When done correctly, there is no impact on users other than a brief service restart.

## Relationship to auth.id

The `auth.id` setting and the ServerID are related by convention, but they are technically independent.

Changing the commit ServerID is optional and is typically done to align with SDP naming conventions or enterprise-wide naming standards.

Changing `auth.id` is sufficient to resolve ticket collisions and inconsistent authentication behavior. See: [Changing auth.id](Changing_auth.id.md) for more information.

## What the ServerID of the commit server represents

The ServerID uniquely identifies a server within a P4 Server topology.

For a commit server, the ServerID is a core identity element that is referenced by:

- Replica and standby server specifications
- Replication configuration and state
- Service users and automation associated with the commit server

Replica and standby servers identify their upstream server by ServerID, not by hostname or DNS name. Because of this, the commit ServerID is an important element of the replication topology.

## Impact of changing the commit ServerID

Changing the commit ServerID, done right, has no impact on users except for a brief outage require for a service restart, requiring only seconds.

Planning considerations:

* The change of the `server.id` file in P4ROOT on the commit server must be performed with the p4d process stopped.
* The commit server must be restarted for the new ServerID to take effect.
* Any configurables associated with old ServerID of the commit server, such as `startup.N` settings for LDAP integration, must be duplicated to the chosen new ServerID.
* All replicas and standby servers that reference the commit ServerID in the `RepflicatingFrom:` field of their server specs must be updated.
* Replication will be briefly interrupted while servers are restarted and reconnect.
* The duplicated configurables can have their corresponding configurables for the original ServerID removed once the services are back up.

When the above are accounted for, this change has no impact on users.

## Required follow-on changes

Changing the commit ServerID is not a single isolated action. The following follow-on steps are required.

### Update replica and standby server specifications

For each replica or standby server that replicates from the commit server:

* Edit the server specification using `p4 server <ServerID>`.
* Update the `ReplicatingFrom:` field to reference the new commit ServerID.

### Restart replica and standby servers

After updating the server specifications:

* Restart the p4d process on each replica and standby server.

A restart is required for the replica to pick up the updated ServerID and ReplicatingFrom relationship and to resume replication cleanly.

## Operational considerations

* Schedule a short maintenance window that includes the commit server and all replicas.
* Expect a brief interruption to replication during the change.
* Verify replication status after all servers have restarted.
* Ensure monitoring or health checks confirm that replicas are connected to the new commit ServerID.

## Related Information

See: [Changing auth.id](Changing_auth.id.md) for more information on changing `auth.id`.