# shellcheck disable=SC2148 disable=SC2034
declare Version=2.2.0
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

#==============================================================================
# Library Functions.

#------------------------------------------------------------------------------
# Function: getLocalPath
#
# Input:
# $1 - p4Path in depot or client syntax, e.g. "//depot/main/foo.c"
#
# Usage Example: localPath=$(getLocalPath "//depot/main/foo.c")
#------------------------------------------------------------------------------
function getLocalPath {
   declare p4Path=$1
   declare localPath

   [[ -n "$p4Path" ]] || return

   localPath=$(p4 -ztag where "$p4Path"|grep "^\.\.\. path"|tail -1)
   localPath=${localPath#... path }
   localPath=${localPath%\/\.\.\.}
   echo -n "$localPath"
}
