#!/usr/bin/env python

"""
Usage:
	python checkusers_not_in_group.py

This script will generate a list of all standard Perforce user names that are not listed in any group.
It prints the results to the screen, so you may want to redirect it to a file.
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import re
import sys
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

users = []
groupusers = []
groups = []


def main():
  try:
    for user in os.popen("%s users" % p4).readlines():
      user = re.sub(r" <.*", r"", user)
      user = user.strip()
      user = user.lower()
      users.append(user)
  except:
    print("Non unicode user name on server. Some user names may have been skipped.")

  for group in os.popen("%s groups" % p4).readlines():
    group = group.strip()
    groups.append(group)

  for group in groups:
    pastUsers = 0
    for user in os.popen("%s group -o %s" % (p4, group)).readlines():
      user = user.strip()
      if re.match(r"Users:", user):
        pastUsers = 1
        continue
      if pastUsers == 1:
        user = user.lower()
        if user in groupusers:
          continue
        else:
          groupusers.append(user)

  groupusers.sort()

  for user in users:
    if user in groupusers:
      continue
    else:
      print(user)


###############################################################################
# main
if __name__ == "__main__":
  main()
