#!/usr/bin/env python

"""
This script will count the total number of files and revisions from a list of files
in the Perforce server.

Usage:
	Run p4 files //... > files.txt, then run:

	python countrevs.py files.txt
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import sys, re


def main():
  if len(sys.argv) <= 1:
    print("Read the usage section at the top of the script for required parameters.")
    sys.exit(1)

  input = open(sys.argv[1], "r")

  filecount = 0
  revcount = 0

  for line in input.readlines():
    filecount = filecount + 1
    revcount = revcount + int(re.search(r"#(\d+)", line).group(1))

  print("Total number of files = %s" % (filecount))
  print("Total number of revisions = %s" % (revcount))

  input.close()

###############################################################################
if __name__ == '__main__':
  main()
