#!/usr/bin/env python

"""
This script creates a list of email address for your users directly from their
Perforce user accounts. It is intended to be used as part of email.bat, but can
be used with any mail program that can read addresses from a list.
"""

import os
import re
import sys
import sdputils

if len(sys.argv) > 1:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


def main():
  os.system("%s users > p4users.txt" % p4)

  input = open("p4users.txt", "r")
  output = open("emaillist.txt", "w")

  for line in input.readlines():
    line = line.strip()
    line = re.sub(r".*<", r"", line)
    line = re.sub(r">.*", r"", line)
    output.write(line + "\n")

  input.close()
  output.close()

  os.remove("p4users.txt")

######################################################################################################
if __name__ == '__main__':
  main()
