#!/usr/bin/env python

"""
Usage:
	python protect_groups.py [instance] protect_groups.txt > remove_groups.txt

instance defaults to 1 if not given.

This script will list all the groups mentioned in "p4 protect" that are not a Perforce group.
You need to pull the groups from p4 protect with:

p4 protect -o | grep group |  cut -d " " -f 3 | sort | uniq > protect_groups.txt and pass protect_groups.txt to this script.
"""

import os
import sys
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
  protect_groups = sys.argv[2]
else:
  SDP_INSTANCE = '1'
  protect_groups = sys.argv[1]

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

p4groups = []
groupusers = []


def main():
  if len(sys.argv) < 1:
    print(
      "This script requires a file with the list of groups in the protections table as a parameter. See the top of the script for instructions.")

  try:
    for group in os.popen("%s groups" % p4).readlines():
      group = group.rstrip()
      group = group.lower()
      p4groups.append(group)
  except:
    print("Non unicode group name on server. Some group names may have been skipped.")

  input = open(protect_groups, "r")

  for line in input.readlines():
    line = line.rstrip()
    line = line.lower()
    if line in p4groups:
      continue
    else:
      print(line)
  input.close()


###############################################################################
# main
if __name__ == "__main__":
  main()
