#!/usr/bin/env python

"""
Usage:
	remove_jobs.py [SDP_INSTANCE] list_of_jobs

This script will remove all of the fixes associated with jobs and then delete
the jobs listed in the file passed as the first argument. The list can be
created with p4 jobs > jobs.txt. The script will handles the extra text one
the lines.
"""

import os
import re
import sys
import platform
import sdputils

USAGE = """
Usage:
	remove_jobs.py [SDP_INSTANCE] <textfile>

textfile should be a file containing 1 job per line.
"""

if len(sys.argv) < 2:
  print(USAGE)
  sys.exit(1)

if len(sys.argv) > 2:
  SDP_INSTANCE = str(sys.argv[1])
  jobs_file = sys.argv[2]
else:
  SDP_INSTANCE = '1'
  jobs_file = sys.argv[1]

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


def main():
  try:
    input = open(jobs_file, "r")
  except:
    print("Unable to open file %s." % jobs_file)
    sys.exit(2)

  for job in input.readlines():
    job = re.sub(r" on .*", r"", job)
    job = re.sub(r"< ", r"", job)
    job = job.strip()
    command = "%s fixes -j %s > fixes.txt" % (p4, job)
    os.system(command)
    if os.path.isfile("fixes.txt"):
      fixes = open("fixes.txt", "r")
      for fixline in fixes.readlines():
        if re.search("fixed by", fixline):
          match = re.match(".* fixed by change (\d+) on .*", fixline).groups()[0]
          os.system("%s fix -d -c %s %s" % (p4, match, job))
      fixes.close()
    os.system("%s job -d %s" % (p4, job))

  input.close()
  os.remove("fixes.txt")


###############################################################################
# main
if __name__ == "__main__":
  main()
