#!/usr/bin/env python

USAGE = """
This script will remove the specified users from given group.

Usage:
 	removeusersfromgroup.py [instance] USER groupname
 	removeusersfromgroup.py [instance] FILE groupname

USER can be a single username or, it can be a FILE with a list of users.

instance defaults to 1 if not given.
"""

import os
import sys
import sdputils

if len(sys.argv) > 3:   # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


def removeuser(username, groupname, groupfile):
  newgroupfile = groupfile + ".new"
  infile = open(groupfile, "r")
  outfile = open(newgroupfile, "w")
  for line in infile.readlines():
    if username.lower() != (line.strip()).lower():
      outfile.write(line)
  infile.close()
  outfile.close()
  os.remove(groupfile)
  os.rename(newgroupfile, groupfile)


def cleanup(groupfile):
  print("Cleaning temp files")
  try:
    os.remove(groupfile)
  except:
    print("Failed to delete " + groupfile)


def main():
  if len(sys.argv) < 3:
    print(USAGE)
    sys.exit(1)

  # Handle the optional instance parameter shift
  if len(sys.argv) > 3:
    userorfile = (sys.argv[2])
    groupname = sys.argv[3].strip()
  else:
    userorfile = (sys.argv[1])
    groupname = sys.argv[2].strip()

  global initialized
  initialized = 0
  groupfile = "%s.group" % groupname
  os.system("%s group -o %s > %s" % (p4, groupname, groupfile))

  try:
    userlistfile = open(userorfile, "r")
    for line in userlistfile.readlines():
      removeuser(line.strip(), groupname, groupfile)
  except:
    print("No file %s available, assuming it is the actual user name." % userorfile)
    removeuser(userorfile, groupname, groupfile)

  os.system("%s group -i < %s" % (p4, groupfile))
  cleanup(groupfile)


if __name__ == '__main__':
  main()
