#!/usr/bin/env python

"""
This script will unload clients that have not been accessed since the number
of weeks specified in the maintenance.cfg file.

This version of unload clients will delete clients with exclusive checkouts
since unload will not unload those clients.

It also deletes shelves from the clients to be deleted since delete will not
delete a client with a shelf.
"""

import os
import re
import sys
import string
import accessdates
import platform
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()
cfgweeks = utils.get('weeks')

###############################################################################
def unload_clients( command, del_command ):
  clients = []
  accessdates.createlist("clients", "client", cfgweeks)

# Generate list of exclusively opened files.
  os.system('%s -ztag opened -a | grep -A 3 "+F*l" > excllist.txt' % (p4))

  if os.path.isfile("excllist.txt"):
    input = open( "excllist.txt", "r" )
    # Create list of clients with exclusively opened files.
    for line in input.readlines():
      line = line.strip()
      if re.search("\.\.\. client ", line):
        client = line[11:]
        client = client.strip()
        clients.append( client )
  
    input.close()
    os.remove( "excllist.txt" )

# Read list of clients to be unloaded.
  if os.path.isfile("clients.txt"):
    clientsfile = open( "clients.txt", "r" )
  
    for client in clientsfile.readlines():
      client = client.strip()
      # Avoid deleting or affecting Swarm clients.
      if (re.match ('^swarm-', client)):
        continue
      # Delete clients with exclusively opened files since unload won't unload them.  
      if client in clients:
        # Delete shelves from client
        client = re.sub("\$", "\\\$", client)
        os.system('%s -Ztag changes -s shelved -c %s > shelved.txt' % (p4, client))
        if os.path.isfile("shelved.txt"):
          shelvedfile = open("shelved.txt", "r")
          for changeline in shelvedfile.readlines():
            if re.search("\.\.\. change ", changeline):
              changenum = changeline[11:]
              changenum = changenum.strip()
              os.system('%s shelve -c %s -df' % (p4, changenum))
          shelvedfile.close()
          os.remove("shelved.txt")
        os.system('%s client -f -d %s' % (p4, client))
      else:
        client = re.sub("\$", "\\\$", client)
        os.system(('%s unload -f -L -z -c %s') % (p4, client))
  
    clientsfile.close()
  os.remove( "clients.txt")

###############################################################################
# main
if __name__ == '__main__':
  # Generate list of clients to be unloaded.
  unload_clients( "clients", "client" )
