# -*- encoding: UTF8 -*-
# Test harness for UserPermissionsReport.py

from __future__ import print_function

import sys
import unittest
import os
import re

import P4
sys.path.append(os.path.join('..', '..', 'triggers', 'tests'))
from p4testutils import TestCase, P4Server, localDirectory, create_file, append_to_file

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, parent_dir)
from UserPermissionsReport import UserPermissionsReport

os.environ["LOGS"] = "."
LOGGER_NAME = "TestUserPermissionsReport"
LOG_FILE = "log-TestUserPermissionsReport.log"


class TestUserPermissionsReport(TestCase):
    def __init__(self, methodName='runTest'):
        super(TestUserPermissionsReport, self).__init__(LOGGER_NAME, LOG_FILE, methodName=methodName)

    def setUp(self):
        self.server = P4Server()
        p4 = self.server.p4
        self.p4 = p4
        p4.logger = self.logger
        # This works if no spaces in server root pathname!
        port = p4.port.replace('"', '')
        self.logger.debug("port: |%s|" % port)
        os.chdir(self.server.root)
        # Reconnect to pick up changes
        #p4.disconnect()
        #p4.connect()
        protect = p4.fetch_protect()
        p4.save_protect(protect)

    def tearDown(self):
        pass

    def testUserPermissionsReport(self):
        """simple test"""

        p4 = self.p4


        # Users
        user1 =  {
            'User': 'firstuser',
            'Email': 'firstuser@perforce.com',
            'FullName': 'First Bobby User'
            }
        user2 =  {
            'User': 'seconduser',
            'Email': 'seconduser@perforce.com',
            'FullName': 'Bjorn Eirik Larsen'
            }
        user3 =  {
            'User': 'thirduser',
            'Email': 'onename@perforce.com',
            'FullName': 'onename'
            }
        p4.save_user(user1, "-f")
        p4.save_user(user2, "-f")
        p4.save_user(user3, "-f")

        # Protections
        protectionView = [
                          "write user * * //... ## standard",
                          "super user testuser * //... ## super user line",
                          "read user thirduser * //...",
                          "list user fourthuser * //depot/some/wild/path/...",
                          "read group otherusergroup * //depot/...",
                          "list group usergroup * //depot/..."
                          ]
           
        protect = p4.fetch_protect()
        protect._protections = protectionView
        p4.save_protect(protect)


        # Groups
        group = p4.fetch_group( "usergroup" )  
        group[ "Users" ] = "firstuser\n"
        p4.save_group( group )

        group = p4.fetch_group( "otherusergroup" )  
        group[ "Users" ] = "seconduser\n"
        p4.save_group( group )

        
        users = p4.run_users()
        self.assertEqual(4, len(users))
        UPR = UserPermissionsReport()
        contents = UPR.generateReport()

        expected = """userID,first,last,email,usertype,group
firstuser,First,User,firstuser@perforce.com,user,usergroup
seconduser,Bjorn,Larsen,seconduser@perforce.com,user,otherusergroup
testuser,testuser,testuser,testuser@test_ws,admin,
thirduser,onename,onename,onename@perforce.com,user,"""
        self.assertEqual(expected,contents)
       



    def testNoProtectionTable(self):
        p4 = self.p4
        #define the protection table lines
        protectionView = [
                          ""
                          ]
        protect = p4.fetch_protect()
        protect._protections = protectionView
        p4.save_protect(protect)
        
        
        
        
    def testAddThreeUsers(self):
        p4 = self.p4
        
        
if __name__ == '__main__':
    unittest.main()
