#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

"""
Usage:
       PreventWSNonASCII form-save client "/p4/common/bin/triggers/PreventWsNonAscii.py %formfile%"

This script is designed to run as a form save trigger on the server.  It will cause
a workspace save to fail if any non-ascii characters are present in the workspace spec.

It also will block odd characters from the workspace name.
"""

import os
import re
import string
import sys

input = open(sys.argv[1], "r")
found = False
allowed = []
allowed.extend(string.whitespace)
allowed.extend(string.punctuation)
allowed.extend(string.digits)
allowed.extend(string.ascii_letters)
pattern =  r"""[^%s]"""
regexp = re.compile(pattern % "".join(allowed))

for line in input.readlines():
    if (re.search(r"^Client:", line) or re.search(r"^Label", line)):
        if re.search(r"[\\!$%^&()<>+=]", line):
            print("\\!$%^&()<>+= not allowed in form name.")
            found = True
            break
    try:
        if re.search(regexp, line.replace("\\","/")):
            print("Non-ASCII characters found in form form: %s" % line)
            found = True
            break
    except:
        print("Non unicode characters in %s" % line)
        found = True
        break

input.close()

if found:
    sys.exit(1)
else:
    sys.exit(0)
