#!/bin/bash
# check_adoc_tables.sh - quick sanity checker for AsciiDoc tables
# Usage: ./check_adoc_tables.sh SDP_Guide.Unix.adoc

file="$1"
cols=0
in_table=false
lineno=0

while IFS= read -r line; do
  ((lineno++))
  # Detect table start
  if [[ $line =~ ^\[cols=\"([0-9]+)\* ]]; then
    cols="${BASH_REMATCH[1]}"
  fi
  if [[ $line == "|===" && $in_table == false ]]; then
    in_table=true
    continue
  fi
  if [[ $line == "|===" && $in_table == true ]]; then
    in_table=false
    cols=0
    continue
  fi
  if $in_table; then
    # Count pipes in this line
    pc=$(grep -o '|' <<<"$line" | wc -l)
    if [[ $pc -gt 0 && $pc -lt $cols ]]; then
      echo "Line $lineno: Too few cells ($pc) for $cols-col table: $line"
    fi
    if [[ $line =~ ^\|$ ]]; then
      echo "Line $lineno: Bare '|' found (likely missing content)."
    fi
  fi
done < "$file"

