# Server Deployment Package

## Unix Installation Guide

---

# Prerequisites

Before installing the SDP, ensure you have the following:

## Storage Volumes

- **Two database volumes** (recommended, not required) – local SSD recommended
  - One for root (live database)
  - One for offline checkpoints and database switching
- **Volume for the depot files**
- **Volume for the journal and logs** – Place on database volume if separate logs volume is not available

## Users and Accounts

- User account to run the Perforce service under (if one doesn't already exist)
- Perforce super user account and password for management (e.g., `p4admin` – not an employee's personal account)

## Server Configuration

- Determine (new server) or check (existing server) the case sensitivity setting of the Perforce server
- `/p4` top level folder (only required ahead of time if root access to the machine is not available during the install)

---

# Installation

## Step 1: Extract the SDP

Download the SDP tarball and place it on the depot files data volume, then extract it:

```bash
tar xvzf sdp.tgz
```

This will create a directory named `sdp`.

## Step 2: Set Permissions

```bash
chown -R perforce:perforce sdp*
```

(Substitute your OS user's name and group if different)

## Step 3: Configure mkdirs.sh

```bash
cd sdp/Server/Unix/setup
vi mkdirs.sh
```

- Check that all configuration section variables are set correctly for your server
- Add the primary admin's email to the `MAILTO` configurable
- Save the file

## Step 4: Add Perforce Binaries

Put a copy of your server's version of `p4` and `p4d` in:

```
sdp/Server/Unix/p4/common/bin
```

## Step 5: Pre-Installation Check

Check to make sure that a file or folder named `p4` does not exist in the top level of any of the install folders.

## Step 6: Run mkdirs.sh

As root, run:

```bash
cd sdp/Server/Unix/setup
./mkdirs.sh <instance number or name>
```

Example:

```bash
./mkdirs.sh 1
```

> **Note:** See the section on [Existing SDP Servers](#existing-sdp-servers) for servers with an existing SDP install.

## Step 7: Migrate Existing Data

Stop your server and perform the following migrations:

1. Move the production `db.*` files to `/p4/<instance_name>/root`
2. Move the license file to `/p4/<instance_name>/root`
3. Move the journal and log files to `/p4/<instance_name>/logs`
4. Move all depots to `/p4/<instance_name>/depots`

> **Note:** If any depots have hard-coded map fields, create temporary symlinks from the new location to the old location. After starting the server, update the depots to remove any hard-coded mappings. After that, remove the temporary symlinks.

## Step 8: Configure System Startup

Follow the directions in `/p4/sdp/Server/Unix/setup/systemd/README.md` to configure the system startup files.

## Step 9: Set File Ownership

Make sure all files are owned by the perforce user:

```bash
sudo su - perforce
```

## Step 10: Initialize the Server

```bash
/p4/<instance_name>/bin/p4d_<instance_name> -r /p4/<instance_name>/root \
    -J /p4/<instance_name>/logs/journal \
    -cset server.depot.root=/p4/<instance_name>/depots
```

## Step 11: Start the Server

```bash
systemctl start p4d_1
```

## Step 12: Configure the Server

Set up your environment to connect to your server:

```bash
source /p4/common/bin/p4_vars <instance>
```

Then run:

```bash
p4 configure set journalPrefix=/p4/<instance_name>/checkpoints/p4_<instance_name>
```

Also set any other configurables from `/p4/sdp/setup/configure_new_server.sh` that you want to use for your server.

> **Tip:** You can edit the `configure_new_server.sh` script and run it:
> ```bash
> ./configure_new_server.sh <instance_name>
> ```

## Step 13: Configure Crontab

```bash
cd /p4
vi p4.crontab
```

- Change `instance=1` to `instance=<instance_name>`
- Check the times for running the scripts and update as necessary
- Comment out any scripts you don't want to run
- Save the file

Load the new crontab:

```bash
crontab p4.crontab
```

## Step 14: Verify Installation

Run some checks to make sure everything looks correct:

```bash
p4 info
p4 depots
```

---

# Offline Checkpoints

## Setting Up Offline Database

If you have an offline set of db files, move those into `/p4/<instance_name>/offline_db`.

If you do not have offline db files, recover the most recent checkpoint into the offline_db folder.

After the db files are in the offline_db folder, create the marker file:

```bash
touch /p4/<instance_name>/offline_db/offline_db_usable.txt
```

## Testing Offline Checkpoints

To test the offline checkpoint process, run:

```bash
/p4/common/bin/daily_checkpoint.sh <instance_name>
```

When it finishes, you should receive an email containing the contents of:

```
/p4/<instance_name>/logs/checkpoint.log
```

---

# Existing SDP Servers

For servers where an older version of the SDP exists:

## Step 1: Prepare for Migration

1. Stop the existing server
2. Go to each volume where a `p4` directory exists and rename it:
   ```bash
   mv p4 p4.orig
   ```
3. Remove the symlinks in `/p4`
4. Rename the crontab files:
   ```bash
   mv p4.crontab p4.crontab.old
   mv p4.crontab.replica p4.crontab.replica.old
   ```

## Step 2: Install New SDP

Update `mkdirs.sh` with your settings and install the new SDP.

## Step 3: Migrate Data

Move the following from the `p4.orig` directories to the newly installed `p4` directories:

- Data files (db.*, depots, etc.)
- Triggers
- Any custom scripts

## Step 4: Restart and Verify

Restart the server and test to make sure everything is working correctly.

## Step 5: Clean Up

If everything is working, you can remove the `p4.orig` directories.

## Step 6: Update Crontab

Update the crontab to use any newly named scripts per:

- `/p4/p4.crontab` - for master servers
- `/p4/p4.crontab.replica` - for replica servers
- `/p4/p4.crontab.edge` - for edge servers

Choose the appropriate crontab file depending on the type of server you are upgrading.
