# shellcheck disable=SC2148 disable=SC2034
declare Version=2.2.1
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

#==============================================================================
# Standard Environment for bash scripts.

# Use 'set -a' mode to export everything in this file.
set -a

# Require variables to be declared.
set -u

# Set aliases for common commands.  This is a safety/security precaution to
# help ensure intended commands are run, rather than identically named
# programs elsewhere in the PATH.  Paths may need to adjusted if run on
# different systems.

alias rm=/bin/rm
alias mkdir=/bin/mkdir
alias mkpath="/bin/mkdir -p"
alias printf="/usr/bin/printf"

# Define a temporary directory.
declare P4U_TMPDIR="${P4TMP:-/tmp}/tmp.$$.$RANDOM"
[[ ! -d "$P4U_TMPDIR" ]] && mkdir "$P4U_TMPDIR"

# Initialize GARBAGE to contain the $P4U_TMPDIR.  GARBAGE contains a list
# of files and/or directories to be removed (with rm -rf) upon termination
# of the script.
# shellcheck disable=2034
declare GARBAGE="$P4U_TMPDIR"
# shellcheck disable=2034
declare RGARBAGE=""

# Provide a baseline default VERBOSITY.  Scripts may override this to define
# a default for a specific script.  Script users may override this on a per-run
# basis. Scale:
# 1=errors only
# 2=errors and warnings
# 3=normal
# 4=verbose
# shellcheck disable=2034
declare -i VERBOSITY=5

# Store just the name of the current script, useful for logging.
# shellcheck disable=2034
declare THISSCRIPT=${0##*/}

# Store the initial command line in $CMDLINE, useful for logging.
# shellcheck disable=2034
declare CMDLINE="$0 $*"

# Initialize the NO_OP ("no operation") test mode.  If set to 1, scripts
# interpret this to mean "show what would be done, without executing any
# data-affecting commands."
# shellcheck disable=2034
declare -i NO_OP=0

# Globals for runCmd() and run(), containing last command and its exit code.
# runCmd() also stores output in $CMDOUTPUT; run() does not.
# shellcheck disable=2034
declare CMDLAST=""
# shellcheck disable=2034
declare -i CMDEXITCODE=0
# shellcheck disable=2034
declare CMDOUTPUT=""

# Globals for runRemoteCmd() and rrun(), containing last command and its exit code.
# runRemoteCmd() also stores output in $RCMDOUTPUT; rrun() does not.
# shellcheck disable=2034
declare RCMDLAST=""
# shellcheck disable=2034
declare -i RCMDEXITCODE=0
# shellcheck disable=2034
declare RCMDOUTPUT=""

# Header, 79 characters of screen-splitting divider.
declare H="\n==============================================================================="
# shellcheck disable=2034
declare H1="${H}"
# shellcheck disable=2034
declare H2="\n------------------------------------------------------------------------------"

# At the end of this file, return to default behavior, undoing 'set -a' above.
set +a
