Best Practices Settings Guidance
===

Configurable Settings
---

The `configure_new_server.sh` script (and `configure_new_server.bat` for Windows)
serve as a guide defining best-practice configurables for a production environment (or a realistic PoC).

See documentation regarding configurables:
[here](https://help.perforce.com/helix-core/server-apps/cmdref/current/Content/CmdRef/configurables.alphabetical.html).

Here is some insight into the thinking that goes into setting configurables in the SDP.  The SDP configurables are different from P4D defaults for a variety of reasons, such as:

* In some cases, SDP has standards related to its directory structure, for
  things like `server.depot.root` and `journalPrefix`.
* In some cases, P4D defaults are (rightly) optimized for ease of installation in basic demo/PoC scenarios, where the SDP sets production-grade defaults, e.g. `filesys.*.min`, `monitor`, `server`, and some structured logs -- plus a recommendation for setting `security`.
* In some cases, the SDP is more willing to adopt settings expected to be good
  for most environments (if not quite universal), e.g. setting `lbr.autocompress`, `lbr.bufsize`, `net.backlog`, `net.autotune`, `net.tcpsize`, etc.  P4D is
  (rightly) more conservative when changing such defaults, perhaps requiring more proof/data, while the SDP is willing to promote settings changes ahead of P4D if folks in Engineering/Support/Consulting believe they'll be mostly good. In some cases, this may help get the more solid proof/data needed to change p4d defaults.

Other Settings
---

Besides configurable settings, the SDP also adjusts P4D defaults and behaviors in other ways, such as always creating 'spec' and 'unload' depots.

Window Servers
---
See the Windows-specific setup files in:

..\Windows\setup

In particular:

* `SDPEnv.py`
* `template_configure_new_server.bat`

Applying Settings to Existing Servers
---
As the name implies, these `configure_new_sever.*` scripts are intended to be run on a new server.  When applied to an existing data set, it is recommended that these scripts be used as a guide. In that case, each setting can be applied manually, e.g. with `p4 configure` commands, creating spec/unload depots, etc.  When applying to an existing setting, there are a few things to be aware of:

* The `journalPrefix` and `server.depot.root` configurables are central to SDP operation, and must not be changed.
* The `filesys.*.min` settings are key safety settings. It is OK to adjust the values to suit your environment, but they should always be set in a production environment.
* To see how journalPrefix is set on replicas, see logic in `mkrep.sh`.
* There can be only one depot of type `spec` or `unload`; check that they do not already exist (possibly with a different name).
* While this script does not explicitly unset `dm.integ.engine`, we strongly recommend unsetting `dm.integ.engine` if it is set and P4D is 2014.1 or later.  This isn't done in the script as doing so will cause a significant change in user-visible behavior if it had previously been explicitly set, e.g. to `2`. 
* If you have settings on your server that had been set that are not referenced in this script, or are referenced but with different values, make a decision on what to do with each individual configurable base on merits.

