#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

"""
Usage:
       SetWsOptsAndView form-out client "/p4/common/bin/triggers/SetWsOptionsAndView.py %formfile% %argsQuoted%"

This script is designed to run as a form out trigger on the server. It
will set default for new clients as follows:
* Preset the options set in the OPTIONS variable,
* Change the SubmitOption from "submitunchanged" to "leaveunchanged", and
* Initialize the view to something that forces the user to set a reasonable
  default.
* Pass through -t template content unmodified.

Do not use both SetWsOptions.py and SetWsOptionsAndView.py.
"""

import os
import re
import string
import sys
import random
import shutil

# This dictionary is a list of default options paired with the desired options.
# You only need to include the options you want to change.
OPTIONS = {}
OPTIONS["nomodtime"] = "modtime" 
OPTIONS["normdir"] = "rmdir"

# If trigger invoked with second usage form and user's client command specified a -t template,
# leave form content (from template) unchanged and exit early
if (len(sys.argv)>2) and (re.search(r"(^|,)-t,",sys.argv[2])):
    sys.exit(0)

tempfile = str(random.random())
input = open(sys.argv[1], "r")
output = open(tempfile, "w")
existing = False
isStreamWorkspace = False

for line in input.readlines():
    if re.search(r"^Access:", line):
        existing = True
        break
    try:
        if re.search(r"^Client:", line):
            ws_name = line.split()[1]

        if re.search(r"^Options:", line):
            for defaultvalue in iter(OPTIONS):
                line = re.sub(defaultvalue, OPTIONS[defaultvalue], line)

        if re.search(r"^SubmitOptions:", line):
            line = re.sub("submitunchanged", "leaveunchanged", line)

        if re.search(r"^Stream:", line):
            isStreamWorkspace = True

        if (re.search(r"^View:", line) and (not isStreamWorkspace)):
            output.write(line)
            output.write("\t//EditMe-AdjustThisPath/... //%s/AndThisPath/..." % ws_name)
            break
        output.write(line)

    except:
        print("Non unicode characters in %s" % line)


input.close()
output.close()

if existing == False:
    os.remove(sys.argv[1])
    shutil.copy(tempfile, sys.argv[1])
os.remove(tempfile)

sys.exit(0)
