#!/usr/bin/env python

"""
Usage:
  python checkusers.py

This script will generate a list of all user names that are listed in any group,
but do not have a user account on the server. The results are written to removeusersfromgroups.txt.
You can pass that to removeuserfromgroups.py to do the cleanup.
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import re
import sys
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

users = []
groupusers = []
groups = []


def main():
  try:
    for user in os.popen("%s users -a" % p4).readlines():
      user = re.sub(r" <.*", r"", user)
      user = user.strip()
      user = user.lower()
      users.append(user)
  except:
    print("Non unicode user name on server. Some user names may have been skipped.")

  for group in os.popen("%s groups" % p4).readlines():
    group = group.strip()
    groups.append(group)

  for group in groups:
    pastOwners = 0
    for user in os.popen('%s group -o "%s"' % (p4, group)).readlines():
      user = user.strip()
      if re.match(r"Owners:", user):
        pastOwners = 1
        continue
      if pastOwners == 1:
        user = user.lower()
        if user in groupusers:
          continue
        else:
          if not re.search("users:", user):
            if user:
              groupusers.append(user)

  groupusers.sort()

  userfile = open("removeusersfromgroups.txt", "w")

  for groupuser in groupusers:
    if groupuser in users:
      continue
    else:
      userfile.write("%s\n" % groupuser)

  userfile.close()


###############################################################################
# main
if __name__ == "__main__":
  main()
