#!/usr/bin/env python

"""
This script will delete shelves and clients that have not been accessed
in the number of weeks defined by the variable weeks in maintenance.cfg.
 
Run the script as:

del_shelve.py [instance]

If no instance is given, it defaults to 1.
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import re
import sys
import accessdates
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()
cfgweeks = utils.get('weeks')

def archive(command, del_command, weeks):
  accessdates.createlist(command, del_command, weeks)

  input = open("clients.txt", "r")

  for line in input.readlines():
    line = line.rstrip()
    os.system('%s -Ztag changes -s shelved -c %s > shelved.txt' % (p4, line))
    shelvedfile = open("shelved.txt", "r")
    for changeline in shelvedfile.readlines():
      if re.search("\.\.\. change", changeline):
        changenum = changeline[11:]
        changenum = changenum.strip()
        os.system('%s shelve -c %s -df' % (p4, changenum))
    os.system('%s client -f -d %s' % (p4, line))
    shelvedfile.close()
    os.remove("shelved.txt")

  input.close()
  os.remove("clients.txt")


def main():
  archive("clients", "client", cfgweeks)


###############################################################################
# main
if __name__ == '__main__':
  main()
