#!/usr/bin/env python

"""
This script will add a user to all the groups of another user in Perforce.

Usage:

	python mirroraccess.py instance user1 user2 <user3> <user4> ... <userN>

user1 = user to mirror access from.
user2 = user to mirror access to.
<user3> ... <userN> = additional users to mirror access to.
"""

import os
import sys
import sdputils

if len(sys.argv) < 4:
  print("You have to pass three parameters in for this script.")
  print("The instance number of the server, the User to mirror access from, and the user to mirror access to.")
  sys.exit(1)

SDP_INSTANCE = str(sys.argv[1])

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


######################################################################################################
def main():
  mirroreduser = sys.argv[2]

  os.system("p4 groups %s > mirror_groups.txt" % (mirroreduser))
  groups = open("mirror_groups.txt", "r")

  for group in groups.readlines():
    group = group.rstrip()
    os.system("p4 group -o %s > mirror_group.txt" % (group))
    input = open("mirror_group.txt", "r")
    output = open("mirror_newgroup.txt", "w")
    for line in input.readlines():
      if line != "\n":
        output.write(line)
    for newuser in sys.argv[3:]:
      output.write("\t%s\n" % (newuser))
    input.close()
    output.close()
    os.system("p4 group -i < mirror_newgroup.txt")
    os.remove("mirror_group.txt")
    os.remove("mirror_newgroup.txt")

  groups.close()
  os.remove("mirror_groups.txt")


######################################################################################################
if __name__ == '__main__':
  main()
