#!/usr/bin/python

"""
This program should unlock a perforce label.

The only command line parameter is the label
p4unlock.py labelname
"""

import isitalabel
import os
import re
import sys

def unlock(label):
  lock_pattern = re.compile(r"^Options:\s+locked")
  owner_pattern = re.compile(r"^Owner:\s+(.*)")
  
  # Check to see if the labels exist
  x = isitalabel.check(label)
  if x == 0:
    print ("There is no label %s.") % (label)
    sys.exit(1)
  tempfile = open("temp.txt", "w")
  linelist = []
  ownerfile = open("owner.txt", "w")

  # owner.txt is a one line file generated by the this script. It saves
  # the name of the label owner so it can be put back by p4lock.py.
  # The owner line is removed by this script because Perforce doesn't allow 
  # anyone except the owner of a label to update the label.
  
  for line in os.popen("p4 label -o %s" % (label), "r").readlines():
    match = owner_pattern.match(line)
    if match:
      owner= match.group(1)
      ownerfile.write(owner)
      line = owner_pattern.sub(r"", line)
    line = lock_pattern.sub(r"Options:	unlocked", line)
    linelist = linelist + [line]

  tempfile.writelines(linelist)
  tempfile.close ()
  ownerfile.close()
  os.system("p4 label -i -f < temp.txt")
  os.remove("temp.txt")

def main():
  if len(sys.argv) < 2:
    print ('Invalid input')
    print ('You must specify a label')
    print ('usage: p4unlock.py LABELNAME')
  else:
    label = sys.argv[1]
    unlock(label)

###########################################################################
# main
if __name__ == '__main__': 
  main()

