#!/usr/bin/env python

"""
Usage:
 	remove_empty_pending_changes.py

This script will remove all of the empty pending changelists on the server.
"""

import os
import re
import sys
import sdputils

if len(sys.argv) > 1:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


def main():
  os.system( '%s changes -s pending | grep -i -v swarm | cut -d " " -f 2 > pending.txt' % p4 )

  input = open( "pending.txt", "r" )

  for changenum in input.readlines():
    changenum = changenum.strip()
    os.system ('%s change -fd %s' % (p4, changenum))

  input.close()
  os.remove( "pending.txt" )


###############################################################################
# main
if __name__ == "__main__":
  main()
