#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------


"""
Usage:
       jobs-cmd-filter command pre-user-jobs "/p4/common/bin/triggers/JobsCmdFilter.py %args%"

This script is designed to run as a jobs command filter trigger on the server.
It ensures that multiple wildcards are not specified in any search string
(which can cause the server to perform excessive processing and impact performance)
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import sys
import re

class JobsCmdFilter:
    """ Filters out known issues with jobs search parameters"""

    def __init__(self, *argv):
        """ Initialization.  Process command line argument and initialize logging.
        """
        self.args = argv

    def run(self):
        """Runs trigger"""
        wildcard_pattern = re.compile("^\*+$|'\*+'|\*\*+|=\*'|=\*$")
        for arg in self.args:
            if wildcard_pattern.search(arg):
                print("Please do not specify bare wildcard patterns (*) in a jobs search parameter")
                return(1)
        return 0

if __name__ == '__main__':
    """ Main Program"""
    trigger = JobsCmdFilter(*sys.argv[1:])
    sys.exit(trigger.run())
