# -*- encoding: UTF8 -*-
# Test harness for ExampleTemplate.py

from __future__ import print_function

import sys
import unittest
import os
import re

import P4
sys.path.append(os.path.join('..', '..', 'triggers', 'tests'))
from p4testutils import TestCase, P4Server, localDirectory, create_file, append_to_file

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, parent_dir)
from ExampleTemplate import ExampleTemplate

os.environ["LOGS"] = "."
LOGGER_NAME = "TestExampleTemplate"
LOG_FILE = "log-TestExampleTemplate.log"


class TestExampleTemplate(TestCase):
    def __init__(self, methodName='runTest'):
        super(TestExampleTemplate, self).__init__(LOGGER_NAME, LOG_FILE, methodName=methodName)

    def setUp(self):
        self.server = P4Server()
        p4 = self.server.p4
        self.p4 = p4
        p4.logger = self.logger
        # This works if no spaces in server root pathname!
        port = p4.port.replace('"', '')
        self.logger.debug("port: |%s|" % port)
        # Reconnect to pick up changes
        p4.disconnect()
        p4.connect()

    def tearDown(self):
        pass

    def testExampleTemplate(self):
        """simple test"""

        p4 = self.p4

        users = p4.run_users()
        self.assertEqual(1, len(users))

        # inside = localDirectory(self.server.client_root, "inside")
        # outside = localDirectory(self.server.client_root, "outside")
        # file1 = os.path.join(inside, "file1")
        # file2 = os.path.join(inside, "file2")
        # create_file(file1, "Some content")
        # create_file(file2, "Some content2")



if __name__ == '__main__':
    unittest.main()
