# -*- encoding: UTF8 -*-
# Test harness for JobsCmdFilter.py

from __future__ import print_function

import sys
import unittest
import os
import P4
from p4testutils import TestCase, P4Server

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, parent_dir)
from JobsCmdFilter import JobsCmdFilter

python3 = sys.version_info[0] >= 3

class TestJobsCmdFilter(TestCase):

    def __init__(self, methodName='runTest'):
        super(TestJobsCmdFilter, self).__init__(None, None, methodName=methodName)

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testJobsFilter(self):
        "ordinary jobs command is OK"
        trig = JobsCmdFilter()
        self.assertEqual(0, trig.run())
        trig = JobsCmdFilter("")
        self.assertEqual(0, trig.run())
        trig = JobsCmdFilter('-e', 'new')
        self.assertEqual(0, trig.run())
        trig = JobsCmdFilter("-r", "-m100", "-e", "Summary='****'")
        self.assertEqual(1, trig.run())
        trig = JobsCmdFilter("-r", "-m100", "-e", "Summary='**'")
        self.assertEqual(1, trig.run())
        trig = JobsCmdFilter("-r", "-e", "fred**")
        self.assertEqual(1, trig.run())
        trig = JobsCmdFilter("-r", "-e", "fred*")
        self.assertEqual(0, trig.run())
        trig = JobsCmdFilter("-r", "-m100", "-e", "Summary='*'")
        self.assertEqual(1, trig.run())

    def testJobsFilterTrigger(self):
        "ordinary jobs command is OK"
        self.server = P4Server()
        trigpath = os.path.join(parent_dir, "JobsCmdFilter.py")
        p4 = self.server.p4
        triggers = p4.fetch_triggers()
        triggers['Triggers'] = ['jobs-cmd-filter command pre-user-jobs "python ' + trigpath + ' %args%"']
        p4.save_triggers(triggers)
        p4.disconnect()
        p4.connect()
        
        job = p4.fetch_job()
        job['Description'] = "Description1"
        p4.save_job(job)

        jobs = p4.run_jobs()
        self.assertEqual(1, len(jobs))
        self.assertEqual("job000001", jobs[0]['Job'])

        jobs = p4.run_jobs("-e", "Desc*")
        self.assertEqual(1, len(jobs))
        self.assertEqual("job000001", jobs[0]['Job'])

        jobs = p4.run_jobs("-e", "status=*o*")
        self.assertEqual(1, len(jobs))
        self.assertEqual("job000001", jobs[0]['Job'])

        jobs = p4.run_jobs("-e", "*o*")
        self.assertEqual(1, len(jobs))
        self.assertEqual("job000001", jobs[0]['Job'])

        trigger_errmsg = "validation failed: Please do not specify bare wildcard"
        
        try:
            jobs = p4.run_jobs("-e", "'*'")
            self.assertTrue(False, "Expected exception not found")
        except P4.P4Exception as e:
            self.assertRegex(str(e), trigger_errmsg)

        try:
            jobs = p4.run_jobs("-e", "*")
            self.assertTrue(False, "Expected exception not found")
        except P4.P4Exception as e:
            self.assertRegex(str(e), trigger_errmsg)

        try:
            jobs = p4.run_jobs("-e", "status='*'")
            self.assertTrue(False, "Expected exception not found")
        except P4.P4Exception as e:
            self.assertRegex(str(e), trigger_errmsg)
            
        try:
            jobs = p4.run_jobs("-e", 'status="*"')
            self.assertTrue(False, "Expected exception not found")
        except P4.P4Exception as e:
            self.assertRegex(str(e), trigger_errmsg)
            
if __name__ == '__main__':
    unittest.main()
