# Perforce Server Overview

## Overview

This page documents a list of commands to be executed with super user access to give quick and basic insights into a P4D server's topology, complexity, data scale, etc.  This is useful when planning a migration to the [Server Deployment Package (SDP)](https://swarm.workshop.perforce.com/projects/perforce-software-sdp) and/or for Onboarding for P4RA (P4 Remote Administration).

Please have someone with super user access run these commands and capture the output, and then send it back to us here at Perforce Software.

## Instructions

### If on a UNIX/Linux machine

You must be logged in as a super user to the primary/commit server. You can copy and paste the entire block of commands into a terminal window on a Linux machine.  This will create a file p4_server_overview.<hostname>.<timestamp> that caputres the commands executed and their output.  Email that file back to Perforce.

```
script p4_server_overview.$(hostname -s).$(date +'%Y-%m-%d-%H%M%S').txt
cat /etc/os-release
p4 -ztag info
p4 license -u
p4 -s diskspace
p4 configure show allservers
p4 servers -J
p4 -ztag servers
p4 -ztag depots
p4 triggers -o
p4 extension --list --type extensions
p4 extension --list --type global
p4 extension --list --type instance
p4 extension --list --type certs
p4 property -n P4.Swarm.URL -l
p4 keys -e "swarm-*" -m 1
p4 keys -e "git-*" -m 1
p4 typemap -o
p4 jobspec -o
p4 counter change
p4 -s dbstat -s
p4 -s journals -m 3
p4 protects -u remote
exit # This will end the script.
echo Done
```

### If on a Windows machine

You must be logged in as a super user to the primary/commit server. Run the following commands in a command prompt window and capture their output, and email that back to Perforce in a text file.

```
p4 -ztag info
p4 license -u
p4 -s diskspace
p4 configure show allservers
p4 servers -J
p4 -ztag servers
p4 -ztag depots
p4 triggers -o
p4 extension --list --type extensions
p4 extension --list --type global
p4 extension --list --type instance
p4 extension --list --type certs
p4 property -n P4.Swarm.URL -l
p4 keys -e "swarm-*" -m 1
p4 keys -e "git-*" -m 1
p4 typemap -o
p4 jobspec -o
p4 counter change
p4 -s dbstat -s
p4 -s journals -m 3
p4 protects -u remote
```

### General Information

Any annotation you think we can use will be appreciated. For example, if there are custom triggers, describe of the complexity and purpose of those triggers.

In addition, the output of the `p4 protect -o` might be useful, but we exclude that from the list of commands above, as it may be deemed sensitive.

Describe any integrations with other systems that will need to be maintained, such as custom authentication mechanisms, integrations with bug trackers or workflow managers, code review tools other than P4 Code Review, etc.

Finally, provide any information you believe would be helpful in understanding your current environment. This may include key tools used by users, architecture diagrams, and the like.
