#!/bin/bash
set -u

declare ThisScript="${0##*/}"
declare Version=1.3.0
declare -i ErrorCount=0
declare -i Debug=${SDP_DEBUG:-0}
declare -i LocalLogCount=0
declare -a LocalLogList

function msg () { echo -e "$*"; }
function dbg () { [[ "$Debug" -eq 0 ]] || msg "DEBUG: $*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "$ErrorCount"; }

msg "Start test [$ThisScript v$Version]: Change to parallel checkpoint, recover correct checkpoint."

# Setup: Create site/config dir if needed
mkdir -p /p4/common/site/config

msg "Configure parallel checkpoint on commit."

{
   echo export DO_PARALLEL_CHECKPOINTS=4
   echo KEEPCKPS=2
   echo KEEPJNLS=2
   echo KEEPCKPS=2
} > /p4/common/site/config/p4_1.vars.local

msg "Take daily checkpoint on commit."
daily_checkpoint.sh 1 || errmsg "Daily checkpoint failed."
LocalLogList[LocalLogCount]="/p4/1/logs/checkpoint.log"
LocalLogCount+=1

msg "Checking for syntax and unbound errors in scripts used in this test."
for log in "${LocalLogList[@]}"; do
   msg "Checking for 'unbound variable' in: $log"
   grep ':unbound variable' "$log" && \
      errmsg "Found 'unbound variable' error in $log"
   msg "Checking for 'syntax error' in: $log"
   grep ':syntax error' "$log" && \
      errmsg "Found 'syntax error' in $log"
done

exit "$ErrorCount"
