#!/bin/bash
#------------------------------------------------------------------------------
set -u

# Run this from your local directory in your workpsace on //sdp/dev
# corresponding to:
# //guest/perforce_software/sdp/tools
#
# You must have a valid ticket.

declare ThisScript=${0##*/}
declare -i ErrorCount=0
declare OldMajorVersion=
declare NewMajorVersion=
declare OldReleaseCL=
declare NewReleaseCL=
declare NewReleaseDate=
declare VersionDepotFile="//guest/perforce_software/sdp/dev/Version"
declare VersionLocalFile=
declare CL=
declare H1="=============================================================================="
declare H2="------------------------------------------------------------------------------"
declare Log=/tmp/${ThisScript%.sh}.log

function msg () { echo -e "$*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "${2:-$ErrorCount}"; }

# shellcheck disable=SC1091
source ./env.sh
OldMajorVersion=$(p4 print -q //guest/perforce_software/sdp/main/Version |cut -d '/' -f 3)
OldReleaseCL=$(p4 print -q //guest/perforce_software/sdp/main/Version |cut -d '/' -f 4|cut -d ' ' -f 1)
NewReleaseCL=$(p4 -ztag -F %change% changes -s submitted -m 1 //guest/perforce_software/sdp/dev/...)
NewReleaseDate=$(p4 describe -s "$NewReleaseCL" | head -1 | cut -d ' ' -f 6)

# Redirect stdout and stderr to a log file.
exec > >(tee -a "$Log")
exec 2>&1

msg "${H1}\\nLog is: $Log\\n"

echo -n -e "Enter New Major Version: [$OldMajorVersion]: "
while [[ -z "$NewMajorVersion" ]]; do
   read -r NewMajorVersion

   if [[ -n "$NewMajorVersion" ]]; then
      if [[ ! "$NewMajorVersion" =~ ^[0-9]{4}\.[0-9]+$ ]]; then
         msg "Invalid version; form must by YYYY.N."
	 NewMajorVersion=
         echo -n -e "Enter New Major Version: [$OldMajorVersion]: "
      fi
   else
      NewMajorVersion="$OldMajorVersion"
   fi
done

msg "Released: Rev. SDP/MultiArch/${NewMajorVersion}/${NewReleaseCL} ($NewReleaseDate)\\n"

msg "${H2}\\nChanges since change $OldReleaseCL up to $NewReleaseCL (B=Bug, D=Doc, F=Feature).\\n"

for CL in $(p4 -ztag -F %change% changes -s submitted //guest/perforce_software/sdp/dev/...@$((OldReleaseCL+1)),@now); do
   p4 describe -s "$CL" || bail "Could not do: p4 describe -s \"$CL\""
done

VersionLocalFile=$(p4 -ztag -F %path% where "$VersionDepotFile")

if [[ -n "$VersionLocalFile" ]]; then
   msg "Updating $VersionLocalFile file."
   p4 edit "$VersionLocalFile" || bail "Could not do: p4 edit \"$VersionLocalFile\""
   echo "Rev. SDP/MultiArch/$NewMajorVersion/$NewReleaseCL ($NewReleaseDate)." > "$VersionLocalFile"
   p4 diff "$VersionLocalFile"
else
   errmsg "Could not determine local file for $VersionDepotFile"
fi

msg "\\n${H1}\\nLog is: $Log"

exit "$ErrorCount"
