#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Server/Unix/p4/common/bin/replica_cleanup.sh#3 $ $Change: 31617 $'

# This script expects the most recent valid checkpoint to be available in
# $CHECKPOINTS in order for this script to work.
#
# This script is using the following external variables:
#
# SDP_INSTANCE - The instance of Perforce that is being backed up. Always an
# integer value.
#
# P4HOME - Server's home directory.
# P4BIN - Command line client name for the instance being backed up.
# P4DBIN - Server executable name for the instance being backed up.
# P4ROOT - Server's root directory. p4/root, p4_N/root
# P4PORT - TCP/IP port for the server instance being backed up.
# P4JOURNAL - Location of the Journal for the server instance being backed up.
#
#
export SDP_INSTANCE=${SDP_INSTANCE:-Undefined} 
export SDP_INSTANCE=${1:-$SDP_INSTANCE} 
if [[ $SDP_INSTANCE == Undefined ]]; then 
   echo "Instance parameter not supplied." 
   echo "You must supply the Perforce instance as a parameter to this script." 
   exit 1 
fi 

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$SDP_INSTANCE"
# shellcheck disable=SC1091
source /p4/common/bin/backup_functions.sh
# shellcheck disable=SC2034
LOGFILE="${LOGS}/replica_cleanup.log"

######### Start of Script ##########

check_vars
set_vars
rotate_last_run_logs
log "Start $P4SERVER log cleanup"
check_uid
check_dirs
"$P4CBIN/p4login" -service
get_journalnum
remove_old_checkpoints_and_journals
check_disk_space
remove_old_logs
log "End $P4SERVER log cleanup"
mail_log_file "$HOSTNAME $P4SERVER Daily log clean up."
