#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

"""
Usage:
       SetWsOpts form-out client "/p4/common/bin/triggers/SetWsOptions.py %formfile%"

This script is designed to run as a form out trigger on the server. It
will preset the options set in the OPTIONS variable. It also changes
the submit option from "submitunchanged" to "leaveunchanged".

Do not use both SetWsOptions.py and SetWsOptionsAndView.py.
"""

import os
import re
import string
import sys
import random
import shutil

# This dictionary is a list of default options paired with the desired options.
# You only need to include the options you want to change.
OPTIONS = {}
OPTIONS["nomodtime"] = "modtime" 
OPTIONS["normdir"] = "rmdir"

tempfile = str(random.random())
input = open(sys.argv[1], "r")
output = open(tempfile, "w")
existing = False

for line in input.readlines():
    if re.search(r"^Access:", line):
        existing = True
        break
    try:
        if re.search(r"^Options:", line):
            for defaultvalue in iter(OPTIONS):
                line = re.sub(defaultvalue, OPTIONS[defaultvalue], line)
        if re.search(r"^SubmitOptions:", line):
            line = re.sub("submitunchanged", "leaveunchanged", line)
        output.write(line)
    except:
        print("Non unicode characters in %s" % line)

input.close()
output.close()

if existing == False:
    os.remove(sys.argv[1])
    shutil.copy(tempfile, sys.argv[1])
os.remove(tempfile)

sys.exit(0)
