# shellcheck disable=SC2148 disable=SC2034
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Server/Unix/p4/common/lib/libp4u.sh#3 $ $Change: 31617 $'

#==============================================================================
# Library Functions.

#------------------------------------------------------------------------------
# Function: getLocalPath
#
# Input:
# $1 - p4Path in depot or client syntax, e.g. "//depot/main/foo.c"
#
# Usage Example: localPath=$(getLocalPath "//depot/main/foo.c")
#------------------------------------------------------------------------------
function getLocalPath {
   local p4Path=$1
   local localPath

   [[ -n "$p4Path" ]] || return

   localPath=$(p4 -ztag where "$p4Path"|grep "^\.\.\. path"|tail -1)
   localPath=${localPath#... path }
   localPath=${localPath%\/\.\.\.}
   echo -n "$localPath"
}
