# The Site Directory

## Introduction

The `/p4/common/site directory` is the standard location for storing custom or site-specific files that are not part of the SDP package as it comes from Perforce Software.

## Processing During Upgrades

The automated SDP upgrade process ignores the `/p4/common/site` directory tree. Any files in this directory tree will not be affected by SDP upgrades.

## Standard PATH

The SDP Bash Shell Environment mechanism includes `/p4/common/site/bin` in the PATH, so any executable files deployed here will be on the default PATH.

## Custom Scripts and Triggers

The `/p4/common/site` directory tree is a good location under which to add custom scripts, such as custom triggers, locally modified versions of standard SDP triggers, systems integrations, or other site-specific automation relating to Perforce P4.

For example, say you want to modify a trigger provided by the SDP, such as the `/p4/common/bin/triggers/SetWsOptions.py` trigger that comes with the SDP.  **DO NOT** modify that file in the location it was originally deployed to, `/p4/common/bin/triggers`, because any local modifications will be overwritten during the next SDP upgrade.  (For safety, SDP upgrades first make a backup of everything under `/p4/common` before overwriting anything).  Instead, create a `/p4/common/site/bin/triggers` directory (notably under the `site` directory), and copy the trigger you intend to modify into that directory.  Make your modifications in there, and adjust your Triggers table to reference the file from there (or from the depot if desired).

You may also find sample scripts or template config files in the `/p4/sdp/Unsupported` directory tree that are useful in your environment.  Any files which you intend to use should first be copied to the `site` directory, and any needed modifications made in there.

Any locally developed or third-party systems integrations can also be deployed somewhere under the `/p4/common/site` tree, with executable files ideally being placed in `/p4/common/site/bin` so they are on the default PATH.

## Complex Integrations

For more complex scripts, binaries or systems integrations, it is reasonable to create a subdirectory under `site`, which could further have subdirectories as needed, such as `bin`, `cfg`, etc.  As a fictional example, say you have a systems integration called the Friendly Greeting System (FGS).  All files related to could be deployed in a `/p4/common/site/fgs` directory tree, perhaps containing `bin`, `cfg`, and other directories.  Optionally, add symlinks in `/p4/common/site/bin` referring to any executable files in `../fgs/bin`.

Existence of the `fgs` directory under the `site` directory would then be a reasonable indicator of whether the FGS is installed.

## Shell Environment Customization

It is possible to customize the default SDP Bash Shell Environment.

_WARNING_: Customization of the SDP shell environment should be done with great caution.  Customization is generally discouraged; some reasons for this are:

* Syntax errors or typos in custom files can completely break the SDP shell environment mechanism, effectively disabling checkpoint, trigger, and other operations.
* Customizations are not supported by Perforce Technical Support.
* Customizations can create challenges diagnosing issues.

Ensure that any changes you make are tested thoroughly (ideally in a non-production environment).

If custom logic is needed, e.g. to add host-specific behaviors or configure multiple active brokers with different ports, add that custom logic in custom local files that appear in the `/p4/common/site/config` directory. The `config` directory may need to be created manually.

If needed, custom logic to modify the SDP Bash Shell Environment goes into one of several files that are loaded in a specific order. The process starts with `source /p4/common/bin/p4_vars N`, where N is the SDP instance.

```
/p4/common/bin/p4_vars                          <--- The standard SDP Shell Environment File
    /p4/common/site/config/p4_vars.local.d/*    <--- Optional directory for custom global settings/overrides files.
    /p4/common/site/config/p4_vars.local        <--- Optional file for custom global settings/overrides.

/p4/common/config/p4_N.vars                     <--- The standard SDP Instance-Specific Environment file, to define
                                                     things that can vary on a per-instance basis, e.g. port numbers.
    /p4/common/site/config/p4_N.vars.local.d/*  <--- Optional directory for instance-specific settings/overrides files.
    /p4/common/site/config/p4_N.vars.local      <--- Optional file for instance-specific settings/overrides.
```

In the standard SDP files `p4_vars` and `p4_N.vars`, the site-specific files are sourced in are source at the end of the files.  This is designed so that the custom settings have the ability to override settings that may have been made in the standard way.

This mechanism essentially provides a standard way to do non-standard things.

A key tenet for making any local changes is to make things in such a way that the entire `/p4/common` directory tree could be safely copied (say, via `rsync`) to all SDP-managed p4d, p4broker, and p4p server machines in your server fleet.  The gist is that you want the file contents of the shell environment files to be identical an all server machines even if you desire certain host-specific or ServerID-specific behaviors.

### Shell Environment Customization Example 1 - Disable Offline DB Check

## Third Party Plugins

The `/p4/common/site` directory tree is suitable for deploying custom local or third party additions to the SDP.

For example, the [P4 Management System (P4MS)](https://workshop.perforce.com/projects/p4ms) is a layered software product that, when added to the SDP, is installed in the `/p4/common/site/hms` tree.

## Support Status of The Site Directory

All contents of the `/p4/common/site` tree are inherently custom, and as such are not supported by Perforce Technical Support.
