#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Server/Unix/p4/common/bin/ps_functions.sh#3 $ $Change: 31617 $'

# Common functions for using 'ps' to check on process ids.

# get_pids ($exe)
# Usage: Call with an exe name, e.g. /p4/1/bin/p4web_1
#
# Example:
# p4web_pids=$(get_pids $P4WEBBIN)
# p4broker_pids=$(get_pids $P4BROKERBIN)

# This implementation works on Mac OSX and a variety of Unix/Linux systems.
get_pids () {
   exe=$1
   pids=$($PS -ef|$GREP "${exe}"| $GREP -v " $GREP " | $GREP -v "${exe}_init " | $AWK '{print $2}')
   echo $pids
}
