#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Server/Unix/p4/common/bin/rotate_journal.sh#3 $ $Change: 31617 $'

# This script expects the most recent valid checkpoint to be available in
# $CHECKPOINTS in order for this script to work.
#
# This script is using the following external variables:
#
# SDP_INSTANCE - The instance of Perforce that is being backed up. If not
# set in environment, pass in as argument to script.
#
# P4HOME - Server's home directory.
# P4BIN - Command line client name for the instance being backed up.
# P4DBIN - Server executable name for the instance being backed up.
# P4ROOT - Server's root directory. p4/root, p4_N/root
# P4PORT - TCP/IP port for the server instance being backed up.
# P4JOURNAL - Location of the Journal for the server instance being backed up.
# P4SUPPRESSINFOEMAIL - Suppress information emails. Only send error emails. (Default: false)
#
#
export SDP_INSTANCE=${SDP_INSTANCE:-Undefined}
export SDP_INSTANCE=${1:-$SDP_INSTANCE}
if [[ $SDP_INSTANCE == Undefined ]]; then
   echo "Instance parameter not supplied."
   echo "You must supply the Perforce instance as a parameter to this script."
   exit 1
fi

# If environment variable is defined, then use that as default value if cli arguments not supplied
export P4SUPPRESSINFOEMAIL=${P4SUPPRESSINFOEMAIL:-false}
export P4SUPPRESSINFOEMAIL=${2:-$P4SUPPRESSINFOEMAIL}

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$SDP_INSTANCE"
# shellcheck disable=SC1091
source /p4/common/bin/backup_functions.sh
# shellcheck disable=SC2034
LOGFILE="$LOGS/checkpoint.log"

######### Start of Script ##########

check_vars
set_vars
rotate_last_run_logs
log "Start $P4SERVER journal rotation"

if [[ "$SERVERID" != "$P4MASTER_ID" ]]; then
   die "This rotate_journal.sh script must run only on the master (ServerID=$P4MASTER_ID).\\nThe current ServerID is $SERVERID."
fi

check_uid
check_dirs
ckp_running
/p4/common/bin/p4login
get_journalnum
get_offline_journal_num
truncate_journal
replay_journals_to_offline_db
remove_old_checkpoints_and_journals
remove_old_logs
log "End $P4SERVER journal rotation"
if [[ "${P4SUPPRESSINFOEMAIL,,}" == "false" ]]; then
    mail_log_file "$HOSTNAME $P4SERVER journal rotation"
fi
ckp_complete
