#!/usr/bin/env bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Server/Unix/p4/common/bin/run_if_proxy.sh#3 $ $Change: 31617 $'

instance=${1:-${SDP_INSTANCE:-UnsetSDPInstance}}
[[ "$instance" == UnsetSDPInstance ]] && \
   { echo "Instance parameter required unless SDP_INSTANCE is defined."; exit 1; }

shift
# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$instance"
# shellcheck disable=SC1091
source /p4/common/bin/backup_functions.sh
set_vars

# shellcheck disable=SC2154
if [[ -x "$P4ProxyInitScript" ]]; then
   exec "$@"
fi
