# ============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
# ----------------------------------------------------------------------------

# tag::includeManual[]
<#
    .Synopsis
        p4env.ps1 sets Powershell and creates a file _setenv.bat for CMD
        
    .Description
        This is provided for convenience for admins at CMD prompt.
        
    .Parameter sdp-instance
        The specified instance to login to.
        
    .Example
        p4env.ps1 Master
        
    .Example
        p4env.ps1 1
#>
# end::includeManual[]

[CmdletBinding()]
param ( [string]$SDPInstance,
        [string]$TempSetEnv)
        
if(-not($SDPInstance)) { Throw "You must supply a value for -SDPInstance" }
if(-not($TempSetEnv)) { $TempSetEnv = "_setenv.bat" }

Set-StrictMode -Version 2.0

# Source the SDP Functions shared between scripts
$SDPFunctionsPath = Split-Path -parent $MyInvocation.MyCommand.Path | Join-Path -childpath "SDP-Functions.ps1" 
. $SDPFunctionsPath

$global:ScriptName = "p4env.ps1"
$global:ScriptTask = "P4 Login"
$global:LogFileName = "p4env.log"

Parse-SDPConfigFile $MyInvocation.MyCommand.Path

try {
    Write-Env-Var-File $TempSetEnv
}
Catch
{
    write-error $error[0].ScriptStackTrace
    LogException $_.Exception
}
