# ============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
# ----------------------------------------------------------------------------

<#
    .Synopsis
        send-test-email.ps1 sends a test email to check email settings.
        
    .Description
        To be run manually - typically after initial configuration
        
    .Parameter sdp-instance
        The specified instance to read values for
        
    .Example
        send-test-email.ps1 Master
        
    .Example
        send-test-email.ps1 1
#>

[CmdletBinding()]
param ([string]$SDPInstance = $(throw "SDPInstance parameter is required."))

Set-StrictMode -Version 2.0

# Source the SDP Functions shared between scripts
$SDPFunctionsPath = Split-Path -parent $MyInvocation.MyCommand.Path | Join-Path -childpath "SDP-Functions.ps1" 
. $SDPFunctionsPath

$global:ScriptName = "send-test-email.ps1"
$global:ScriptTask = "SDP Test Email status"
$global:LogFileName = "send_test_email.log"

Parse-SDPConfigFile $MyInvocation.MyCommand.Path
Create-LogFile

$OrigPath = convert-path .
Set-Location -Path $global:LOGS_DIR

try {
    Log "Start of test email"
    $SMTPPort = "25"
    if ($global:mailhostport -and $global:mailhostport -ne "") {
        $SMTPPort = $global:mailhostport
    }
    Log "Sending email from $global:mailfrom to $global:maillist via host: $global:mailhost on port $SMTPPort"
    Send-Email "${env:computername} ${global:SDP_INSTANCE_P4SERVICE_NAME} ${global:ScriptTask}." $global:LogFileName
    Write-Output "`r`n${global:ScriptTask} completed successfully - see ${global:logfile}"
}
Catch
{
    write-error $error[0].ScriptStackTrace
    LogException $_.Exception
    # No point in emailing failure!
    Write-Output "`r`nFAILED - ${global:ScriptTask} - see ${global:logfile}"
}

Set-Location -Path $OrigPath
