#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

"""
This script makes sure that all Perforce users are in the limits group.
"""

import sys, os, string, re

instance=sys.argv[1]

LimitsFile = ("C:\\p4\\%s\\tmp\\limits.txt" % instance)
NewLimitsFile = ("C:\\p4\\%s\\tmp\\limits.new.txt" % instance)
UsersFile = ("C:\\p4\\%s\\tmp\\users.txt" % instance)

os.system("p4 group -o limits > %s" % LimitsFile)
os.system("p4 users > %s" % UsersFile)

users = open(UsersFile, "r")
limits = open(LimitsFile, "r")
output = open(NewLimitsFile, "w")

userlist = []

for user in users.readlines():
        user = re.sub( r"<.*", r"", user )
        user = user.strip()
        if user != "":
                userlist.append(user)

users.close()

for line in limits.readlines():
        if line != "\n":
                output.write(line)

limits.close()

for user in userlist:
        output.write("\t%s\n" % user)

output.close()

os.system("p4 group -i < %s" % NewLimitsFile)

os.remove("%s" % UsersFile)
os.remove("%s" % LimitsFile)
os.remove("%s" % NewLimitsFile)

