#!/usr/bin/env python
#
# This script will make a lowercase copy of the source folder, and report any conflicts found during the copy.
# Run this script from the source path 
# adjust the target path below.
#
# Pass in the folder to be copied in lower case to the target.
#
# ie:
# To copy /p4/1/depots/depot to /depotdata2/p4/1/depots, run:
#
# cd /p4/1/depots
# lowercp.py depot

import sys
import os
import shutil

TARGETDEPOTPATH='/depotdata2/p4/1/depots/'

def rename_dir(directory):
  # rename current directory if needed
  try:
    if not (os.path.exists(TARGETDEPOTPATH + directory.lower())):
      os.makedirs(TARGETDEPOTPATH + directory.lower())
  except:
    print("Creation of %s failed." % (TARGETDEPOTPATH + directory.lower()))

  # rename children
  for fn in os.listdir(directory):
    path = os.path.join(directory, fn)
    lowpath = TARGETDEPOTPATH + path.lower()
    if (os.path.isfile(path)):
      try:
        if (os.path.exists(lowpath)):
          print("Can't copy %s. Target file exists: %s" % (path, lowpath))
        else:
          shutil.copy(path, lowpath)
      except:
        print("Copy of %s to %s failed." % (path, lowpath))
    else:
      rename_dir(path)

# Run program, using the first argument passed to this python script as the name of the folder
rename_dir(sys.argv[1])


