#!/usr/bin/env python

# Usage:
# This script is used to rename a tree to all lowercase. It is helpful if you are
# trying to convert your server from case sensitive to case insensitive.
#
# It takes the directory to convert as the first parameter.


import sys, os

def rename_dir(directory):
  # rename current directory if needed
  try:
    os.rename(directory, directory.lower())
  except:
    print("Rename of %s failed." % directory)
  directory = directory.lower()

  # rename children
  for fn in os.listdir(directory):
    path = os.path.join(directory, fn)
    lowpath = path.lower()
    try:
      if (path != lowpath):
        print("Renaming %s" % path)
        os.rename(path, lowpath)
    except:
      print("Rename of %s failed." % path)
    path = lowpath

    # rename children within, if this child is a directory
    if os.path.isdir(path):
        rename_dir(path)

###############################################################################
if __name__ == '__main__':
  if len(sys.argv) <= 1:
    print("Read the usage section at the top of the script for required parameters.")
    sys.exit(1)

  rename_dir(sys.argv[1])

