#!/usr/bin/env python
#
# This script emails the owners of each group with instructions on how to validate the membership of the groups they own.
#

import os, sys
import smtplib
from email.mime.text import MIMEText
import sdputils

if len(sys.argv) > 1:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

fromAddr = utils.get('administrator')
replyToAddr = ''
mailSMTPhost = utils.get('mailhost')
mailSMTPport = int(utils.get('mailport'))
mailsecure = int(utils.get('mailsecure'))
if mailsecure:
  mailUser = utils.get('mailuser')
  mailPass = utils.get('mailpass')


def email_owner(group, owner):
  message = """
  You are the owner of this group: %s

  As the owner, you are expected to audit the group membership on a quarterly basis.

  To edit/review the group membership, open a command prompt and run:

  p4 group -a %s

  Regards,
  Perforce Admin Team
  %s
  """

  for line in os.popen("p4 -ztag user -o %s" % owner):
    if line.startswith(r"... Email"):
      owner_email = line.lstrip(r"... Email ")
      break

  msg = MIMEText(message % (group, group, fromAddr))
  msg['Subject'] = "%s Group Audit Reminder" % group
  msg['From'] = fromAddr
  if (len(replyToAddr)):
    msg.add_header('reply-to', replyToAddr)
  msg['To'] = owner_email

  try:
    # print("Sending mail to: %s" % owner_email)
    s = smtplib.SMTP(mailSMTPhost, mailSMTPport)
    # Uncomment below for secure connections
    # s.starttls()
    # s.login(mailUser, mailPass)
    s.sendmail(msg['From'], msg['To'], msg.as_string())
    s.quit()
  except smtplib.SMTPException:
    print("Error: unable to send email to %s." % msg['To'])


def main():
  for group in os.popen("p4 groups").readlines():
    owners = 0
    group = group.rstrip()
    for line in os.popen("p4 -ztag group -o %s" % group):
      if line.startswith(r"... Users"):
        break
      if line.startswith(r"... Owners"):
        owners = 1
        owner = line.split()[2]
        email_owner(group, owner)
    if not owners:
      print("%s,No owner." % group)


if __name__ == "__main__":
  main()
