#!/bin/bash
set -u

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/Unsupported/Maintenance/license_status_check.sh#2 $ $Change: 31752 $'

function msg () { echo -e "$*"; }
function bail () { msg "\nError: ${1:-Unknown Error}\n"; exit ${2:-1}; }

export SDP_INSTANCE=${SDP_INSTANCE:-Undefined} 
export SDP_INSTANCE=${1:-$SDP_INSTANCE} 
[[ $SDP_INSTANCE == Undefined ]] &&
    bail "\nUsage:
   ${0##*/} [SDP_INSTANCE]

   Provide an SDP_INSTANCE value (e.g. '1') as a parameter to
   this script, or use it when setting the SDP environment
   by running: source /p4/common/bin/p4_vars 1\n"

source /p4/common/bin/p4_vars "$SDP_INSTANCE"

IsLicensed=$($P4BIN -F %isLicensed% license -u)

if [[ $IsLicensed == yes ]]; then
   LicenseTimeRemaining=$($P4BIN -F %licenseTimeRemaining% license -u)

   if [[ -n "$LicenseTimeRemaining" ]]; then
     msg "License Time Remaining $((LicenseTimeRemaining/86400)) days $((LicenseTimeRemaining/3600%24)) hours $((LicenseTimeRemaining%3600/60)) minutes $((LicenseTimeRemaining%60)) seconds.\n"
   else
      bail "Could not determine license time remaining. A call to '$P4BIN license -u' did not provide a valid response."
   fi
else
   msg "This server is not licensed."
fi
