#!/usr/bin/env python

"""
This script creates groups on the server based on the entries in a local file called groups.txt
The groups.txt file contains:

group,groupname1
username
username
etc
group,groupname2
username
username
etc

Run:
  python creategroups [instance]

Instance defaults to 1 if not given.
"""

from __future__ import print_function

import re
import sys
import os
from subprocess import *
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()


def log(msglevel="DEBUG", message=""):
  if msglevel == "ERROR":
    print(message)
    sys.exit(1)
  else:
    print(message)


def runp4cmd(cmd):
  try:
    pipe = Popen(p4 + cmd, shell=True, stdin=PIPE, stdout=PIPE, universal_newlines=True)
    stdout, stderr = pipe.communicate()
    log("DEBUG", stdout)
    if pipe.returncode != 0:
      log("ERROR", "%s%s generated the following error: %s" % (p4, cmd, stderr))
    else:
      return stdout
  except OSError as err:
    log("ERROR", "Execution failed: %s" % (err))


def main():
  groupsfile = open("groups.txt", "r")
  groupfile = open("group.txt", "w")
  count = 0

  for line in groupsfile.readlines():
    try:
      group = (re.match("^group,(.*)", line).groups())
      if count == 0:
        groupfile.write('Group:\t%s\nUsers:\n' % group[0])
        count = 1
      else:
        groupfile.close()
        cmd = 'group -i < group.txt'
        runp4cmd(cmd)
        os.remove('group.txt')
        groupfile = open("group.txt", "w")
        groupfile.write('Group:\t%s\nUsers:\n' % group[0])
    except:
      groupfile.write('\t%s' % line)

  groupfile.close()
  cmd = 'group -i < group.txt'
  runp4cmd(cmd)
  os.remove('group.txt')


if __name__ == "__main__":
  main()
