#!/usr/bin/env python

"""
This script will email users that their accounts haven't been accessed in the number of weeks defined
in the weeks variable, and warn them that it will be deleted in one week if they do not use it.
"""

from __future__ import print_function

import os
import re
import smtplib
import sys
import time
import traceback
import accessdates
import sdputils

if len(sys.argv) > 1:  # see params above
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
server = utils.server
utils.login()

weeks = int(utils.get('userweeks'))
weeks1warn = int(utils.get('userweeks1warn'))
weeks2warn = int(utils.get('userweeks2warn'))
administrator = utils.get('administrator')
complain_from = utils.get('complain_from')
cc_admin = (utils.get('ccadmin'))
mailhost = utils.get('mailhost')
repeat = int(utils.get('repeat'))
sleeptime = int(utils.get('sleeptime'))

message = """
Your Perforce account hasn't been used in the last %s weeks. It will be deleted
in one week unless you log into Perforce before that time.

Thanks for your cooperation,
The Perforce Admin Team
"""

def complain(mailport, complaint):
  '''
  Send a plaintive message to the human looking after this script if we
  have any difficulties.  If no email address for such a human is given,
  send the complaint to stderr.
  '''
  complaint = complaint + '\n'
  if administrator:
    mailport.sendmail(complain_from, [administrator],
              'Subject: Perforce User Account Deletion Review Daemon Problem\n\n' + complaint)
  else:
    sys.stderr.write(complaint)


def mailit(mailport, sender, recipient, message):
  '''
  Try to mail message from sender to the user using SMTP object
  mailport.  complain() if there are any problems.
  '''

  recipients = []
  recipients.append(recipient)
  if cc_admin:
    recipients.append(cc_admin)

  try:
    failed = mailport.sendmail(sender, recipients, message)
  except:
    exc_type, exc_value, exc_tb = sys.exc_info()
    failed = traceback.format_exception(exc_type, exc_value, exc_tb)

  if failed:
    complain(mailport, 'The following errors occurred:\n\n' + \
         repr(failed) + \
         '\n\nwhile trying to email from\n' \
         + repr(sender) + '\nto ' \
         + repr(recipient) + '\nwith body\n\n' + message)


def warnusers(weeks, mailport):
  accessdates.createlist("users", "user", weeks)

  userlist = open("users.txt", "r")

  for user in userlist.readlines():
    user = user.rstrip()
    os.system('%s user -o "%s" > user.txt' % (p4, user))
    userfile = open("user.txt", "r")
    for userline in userfile.readlines():
      m2 = re.search("^Email:\s(.*)\s", userline)
      if m2:
        email = m2.group(1)
    userfile.close()
    subject = "Subject: User %s on %s server is scheduled for deletion." % (user, server)
    messagebody = 'From: ' + administrator + '\n' + \
            'To: ' + email + '\n' + subject + '\n' + (message % weeks)
    mailit(mailport, administrator, email, messagebody)

  userlist.close()

  if (os.path.isfile("users.txt")):
    os.remove("users.txt")
  if (os.path.isfile("user.txt")):
    os.remove("user.txt")


def loop_body(mailhost):
  # Note: there's a try: wrapped around everything so that the program won't
  # halt.  Unfortunately, as a result you don't get the full traceback.
  # If you're debugging this script, remove the special exception handlers
  # to get the real traceback, or figure out how to get a real traceback,
  # by importing the traceback module and defining a file object that
  # will take the output of traceback.print_exc(file=mailfileobject)
  # and mail it (see the example in cgi.py)
  try:
    mailport = smtplib.SMTP(mailhost)
  except:
    sys.stderr.write('Unable to connect to SMTP host "' + mailhost \
             + '"!\nWill try again in ' + repr(sleeptime) \
             + ' seconds.\n')
  else:
    try:
      warnusers(weeks, mailport)
    except:
      exc_type, exc_value, exc_tb = sys.exc_info()
      complain(mailport, 'Client Deletion Warning Review daemon problem:\n\n%s' % \
           traceback.format_exception(exc_type, exc_value, exc_tb))
    try:
      mailport.quit()
    except:
      sys.stderr.write('Error while doing SMTP quit command (ignore).\n')


def main():
  while (repeat):
    loop_body(mailhost)
    time.sleep(sleeptime)
  else:
    loop_body(mailhost)


###############################################################################
# main
if __name__ == '__main__':
  main()
