#!/usr/bin/python

"""
Determine if a label exists in Perforce.

Usage:
  isitalabel.py labelname

Program will print out results of the search.
Sets ISALABEL in the environment to 0 if found, 1 if not found.
Also will exit with errorlevel 1 if the label is not found
"""

import os
import re
import string
import sys

def check(label):
  update_pattern = re.compile("^Update:.*", re.IGNORECASE)

  os.environ ["ISALABEL"] = "0"
  isfound = 0

  for line in os.popen("p4 label -o %s" % (label)).readlines():
    found = update_pattern.match(line)
    if found != None:
      os.environ ["ISALABEL"]= "1"
      isfound = 1

  return isfound

def main():
  if len(sys.argv) == 2:
    fnd = check(sys.argv[1])
    if fnd == 1:
      print ("The Label %s exists") % (sys.argv[0])
    else:
      print ("The Label %s does not exist.") % (sys.argv[1])
      sys.exit(0)

  if len(sys.argv) > 2:
    print ("You should only enter 1 label name on the command line")

###########################################################################
# main
if __name__ == '__main__':
  main()

