#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------

"""
Usage:
        setlabelopts form-out label "/p4/common/bin/triggers/SetLabelOptions.py %formfile%"
        setlabelopts form-in label "/p4/common/bin/triggers/SetLabelOptions.py %formfile%"

This script is designed to run as a form-in and form-out trigger on the server. It sets the
autoreload option for static labels and doesn't allow the user to change it.
"""

from __future__ import print_function
import sys

def set_label_autoreload(formfile):
    with open(formfile) as f:
        content = f.read()

    content = content.replace("noautoreload", "autoreload")

    with open(formfile, "w") as f:
        f.write(content)

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: SetLabelOptions.py <formfile>")
        sys.exit(0)
    set_label_autoreload(sys.argv[1])

    sys.exit(0)

