#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------
#
# Trigger table entry:
#	TFSJobCheck change-submit //depot/path/... "/p4/common/bin/triggers/TFSJobCheck.py %changelist%"

import os
import sys
import re

###############################################################################
def main():
  changelist = sys.argv[1]

  content = os.popen("p4 describe -s %s" % (changelist)).read()
  print(content)
  if (re.search("Jobs fixed", content)):
    if (re.search("TFS\d+", content)):
      sys.exit(0)
    else:
      print("Job found, but TFS number missing ...")
      sys.exit(1)
  else:
    print("No jobs found, please associate the required TFS job and resubmit.")
    sys.exit(1)

###############################################################################
if __name__ == '__main__':
  main()
