#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://workshop.perforce.com/view/p4-sdp/main/LICENSE
#------------------------------------------------------------------------------
#
# This script checks the input of the description form for the path specified in the triggers table.
#
# Trigger table entry:
#	submitform1_in change-submit //depot/somepath/... "/p4/common/bin/triggers/submit_form_1_in.py %changelist% %user%"

import sys
import os
import platform
import re

USAGE = """
This command requires a changelist as the first parameter.
For Example:
  /p4/common/bin/triggers/submit_form_1_in.py %changelist%
"""

###############################################################################
def main():
  ## Confirm we have enough parameters
  if len(sys.argv) < 2:
    print USAGE
    sys.exit (1)

  changelist = sys.argv[1]
  cmd = os.popen("/p4/common/bin/p4master_run 1 /p4/1/bin/p4_1 describe %s" % changelist, "r")
  exitcode = 1

  for line in cmd.readlines():
    match = re.search(r"Incident:\s+(\d+).*", line)
    if match:
      exitcode = 0

  cmd.close()

  if exitcode:
    print("You did not enter a valid Incident.")

  sys.exit(exitcode)

###############################################################################
if __name__ == '__main__':
  main()
