#!/bin/bash
set -u

# Make it so user has a password.
# Start state: Bruno may or may not already have a password set.
# Just attempt to set it and ignore errors if already set.

#==============================================================================
# Declarations and Environment

# Version ID Block. Relies on +k filetype modifier.
#------------------------------------------------------------------------------
# shellcheck disable=SC2016
declare VersionID='$Id: //p4-sdp/dev_c2s/Server/Unix/p4/common/bin/mkrep.sh#3 $ $Change: 31580 $'
declare VersionStream=${VersionID#*//}; VersionStream=${VersionStream#*/}; VersionStream=${VersionStream%%/*};
declare VersionCL=${VersionID##*: }; VersionCL=${VersionCL%% *}
declare Version=${VersionStream}.${VersionCL}
[[ "$VersionStream" == r* ]] || Version="${Version^^}"

declare SDPInstance=${1:-${SDP_INSTANCE:-1}}

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$SDPInstance"

echo "As user $P4USER, setting password for user bruno."
yes "$(cat "$SDP_ADMIN_PASSWORD_FILE")" | p4 -s passwd bruno

echo "Logging in bruno after password change."
p4 login bruno
