#!/bin/bash
# Tests the SDP - basic tests

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/test/docker/files/test_sdp.sh#3 $ $Change: 31617 $'

declare -i ExitCode=0

/p4/reset_sdp.sh
sudo ln -f -s /sdp/Server/test/test_SDP.py /p4/test_SDP.py
sudo ln -f -s /sdp/Server/test/test_Upgrade.py /p4/test_Upgrade.py

if ! python3 /p4/test_SDP.py --version 24.2; then
   tail /tmp/SDPTest.log
   exit 1
fi

if ! python3 /p4/test_Upgrade.py; then
   tail /tmp/UpgradeSDPTest.log
   exit 1
fi

#------------------------------------------------------------------------------
# To test extraction of custom logic during SDP upgrade, inject some custom
# logic pre-upgrade. Later, we'll test both the extraction and the post-
# extraction shell environment load order.
echo -e "### MAKE LOCAL CHANGES HERE\\nexport TEST_MESSAGE=Life\\n" >> /p4/common/bin/p4_vars
echo -e "### MAKE LOCAL CHANGES HERE\\nexport TEST_MESSAGE+=\" is Good\"\\n" >> /p4/common/config/p4_1.vars
echo -e "export DO_PARALLEL_CHECKPOINTS=6" >> /p4/common/config/p4_1.vars

#------------------------------------------------------------------------------
# Test SDP Upgrade
# This steps are pulled from the 'Upgrading the SDP' section of the SDP
# Guide.
echo Testing the SDP Upgrade Procedure
cd /p4depots
[[ -d downloads ]] || mkdir downloads
cd downloads
[[ -d new ]] && mv new old.$(date +'%Y%m%d-%H%M')
[[ -e sdp.Unix.tgz ]] && mv sdp.Unix.tgz sdp.Unix.old.$(date +'%Y%m%d-%H%M%S')
curl -s -O https://workshop.perforce.com/download/p4-sdp/main/downloads/sdp.Unix.tgz
mkdir new
cd new
tar -xzf ../sdp.Unix.tgz
rsync -a /p4depots/sdp/ /p4depots/downloads/new/sdp
cd /p4depots/downloads/new/sdp/Server/Unix/p4/common/sdp_upgrade

if ./sdp_upgrade.sh -y > /tmp/sdp_upgrade.log 2>&1; then
   echo SDP Upgrade OK.
else
   echo SDP Upgrade FAILED.
   tail /tmp/sdp_upgrade.log
   exit 1
fi

#------------------------------------------------------------------------------
# Call verify_sdp.sh after the SDP upgrade.
echo Calling verify_sdp.sh after the SDP Upgrade.
if /p4/common/bin/verify_sdp.sh 1 > /tmp/post_upgrade_verify.log 2>&1; then
   echo SDP Post-Upgrade Verify Completed OK.
else
   echo SDP Post-Upgrade Verify FAILED.
   tail /tmp/post_upgrade_verify.log
   exit 1
fi

#------------------------------------------------------------------------------
# Test extraction of custom logic after SDP upgrade.

for c in p4_vars.local p4_1.vars.local; do
   if [[ -r "/p4/common/site/config/$c" ]]; then
      echo "Found expected post-upgrade extracted file: $c"
   else
      echo "FAILED: Missing expected post-upgrade extracted file: $c"
      ExitCode=1
   fi
done

source /p4/common/bin/p4_vars 1
Output=$(echo $TEST_MESSAGE)

if [[ "$Output" == *"Life is Good"* ]]; then
   echo "Post-upgrade Test Message is as expected: $Output"
else
   echo "FAILED: Post-upgrade Test Message is not as expected: $Output"
   ExitCode=1
fi

exit "$ExitCode"
